<?php

/*
************************************************************************************************************************
INDICE FUNCIONES
existeUrl($dbConnect, $url)
************************************************************************************************************************
*/

function urlExiste($dbConnect, $url){

    $query = "SELECT * FROM urls WHERE url = ?;";    
    if(!$stmt = $dbConnect->prepare($query)){ errorConexion($dbConnect); }
    $stmt->bind_param("s", $url);
    $stmt->execute();
    $resultado = $stmt->get_result();
    $respuesta = array();
  
    $respuesta = $resultado->fetch_assoc();
      
    return $respuesta;
  }

  function urlInsertar($dbConnect, $url, $urlShort){
    $query = "INSERT INTO urls (url, urlShort) VALUES (?, ?);";        
    if(!$stmt = $dbConnect->prepare($query)){ errorConexion($dbConnect); }    
    $stmt->bind_param("ss", $url, $urlShort);
    
    return array($stmt->execute());
  }


  function obtenerUrl($dbConnect, $urlShort){

    $query = "SELECT url FROM urls WHERE urlShort = ?;";    
    if(!$stmt = $dbConnect->prepare($query)){ errorConexion($dbConnect); }
    $stmt->bind_param("s", $urlShort);
    $stmt->execute();
    $resultado = $stmt->get_result();
    $respuesta = array();
  
    $row = $resultado->fetch_assoc();
    $respuesta = $row['url'];
      
    return $respuesta;
  }

  